  {
This program produce radial distribution of the ED image
from Ratio images 
Before start of this program need to run General_RATany4.v

Output files: 2D arrays (coloumn corresponding to delay, and row to pixel number)
<Path\Radial_1D\TRED> - combined files of intensities at set of delays <FULL(LEFT,RIGHT)>.tif
<Path\Radial_1D\TRED> - corresponding combined files of 3x standard of average 
					    <sigmaFULL(sigmaLEFT,sigmaRIGHT)>.tif

Output files: 1D arrays
<Path\Radial_1D\RAW\> - files <F(L,R)><delay>.csv
<Path\Radial_1D\TRED> - combined files of intensities at set of delays <FULL(LEFT,RIGHT)>.csv
<Path\Radial_1D\TRED> - corresponding combined files of 3x standard of average 
					    <sigmaFULL(sigmaLEFT,sigmaRIGHT)>.csv

created 12/02/2001 by V.Lobastov Ver. 01.
}

const
  	 Prompt = 'Select an image for calculation' ;
		 	  //P ='D:\UED3_Data_processed\Utilities\Delays\*.ini'; 		 	  //default directory for INI file
		  	  	P ='D:\data\UED4_Data_processed\Utilities_UED4\Delays\*.ini'; 		  //default directory for INI file
	 	 
//------------> Global variables
var
	Data;
    F, L, R, T, B;					 			//field image variables for full, left, and right halves CCD}
    M, M_L, M_R, M_T, M_B;						// MASKS   
    Size_x, Size_y; 		  	 	  		 	//image size	 
    SamName;									//name of the file header   
    Fuss;										//image of the apparatus imperfections
	X0,Y0, RR;		
	alpha, beta, CamDist;		   				//elliptical distortion parameters
									
	im, imm; 	 	  	  	   	   		
	cur, curIm, curSDIm, curMask;				//index, current Image, current standard deviation image
	FULL, LEFT, RIGHT;							//combined RAW 1D data
	sigmaFULL, sigmaLEFT, sigmaRIGHT;			//standard deviations for RAW 1D data
	difFULL, difLEFT, difRIGHT;		 			//combined difference 
	sdifFULL, sdifLEFT, sdifRIGHT;	 			//standard deviations for difference

//   Mask_II;                                     //Image Intensifier Mask Image}
//   Image_I;                                     //Input ED Image}

	 NS,NF, Combo;
	 Sel, delay, FL;
	 Sub, Out, Raw, InIMG;
	 Path, PathR, PathU, PathOUT;
	 Start, Loops, Crit;
	 AppMask;
{
******************************************************************
********************** function Select ***************************
******************************************************************
This function return a full file name for a file 
}	 	 

function SELECT;											
		var
   		   nName; Name, ix;
   		   Choice, nDIR;
		begin
	 		 Name:=FindFirstFile(P, fa_Archive);				  	 	 		//Find the first ini file in the delays directory 
	 		 nName:=ExtractFileName(Name);										//Convert the file name and the extension to a string
	 		 nDIR:= ExtractFilePath(Name);										//Return the drive and directory portions of a file name including the trailing backslash
			 ix:=0;																//initialize the variable ix to value of zero
	  		 
			 while StrLen(Name) > 0 do											//If there is a file in the directory, do

	  		 	   begin
	  	   		   		Name:=ExtractFileName(FindNextFile) ;					//Finde the next ini file in the delays directory
		   				nName:=nName+';'+Name;									//Augment the nName string with the next file name
					 if ix>100 then halt('Too many Files in Directory');   		//Stop, if there are more than 100 files
					 	ix:=ix+1;			  	   		 						//Increase the counter ix by 1
	 				end; 

	 			 if SelectString( 'Select File',nName , Choice ) >= 0 then		//If a selection among nName strings is made from the dialog box, then
	 			 	begin
			 			 SELECT:=nDIR+Choice;		  		   	 	  			//Initialize SELECT to the selected ini file
	 				end	
	 			else
	 				begin 
	 	 	  			  WriteInfo('No Selection made! Restart program! ');	//Inform the user that no selection was made
		 	  			  halt;					  						 		//abort the program
	 				end; 
		end;
//----------------------> end of function SELECT <-----------------------------------				

{
******************************************************************
********************** procedure HEADER **************************
******************************************************************
This procedure will generate header for output ASCII file
}

procedure HEADER(com, Head, RF);
   var
   	  im;
	  delay;
   begin
			Write(com,'pix'+RF);			   		 	 		  				//Write an expression to the output window without a terminating carriage-return
   		for im:=NS to NF do														//step through the number of delays
   	   		begin
				   delay:='delay'+Str(im);   									//define the delay number
					Write(com, ',', Head + ReadPrivateINIString( Sel, 'FileNames', delay));	 //write the delay name into the line
	   		end;
					WriteLn(com);		   						 	  			//write a carriage return
	end;	
//------------------> end of procedure HEADER <------------------------------------

{
******************************************************************
********************** procedure OUTRAT **************************
******************************************************************
This procedure will create output ASCII files in TXT format from
combined image contianing the array of 1D radial intensity data
}

procedure OUTRAT(FULLX,FNAME);

var
   Combo;
   jx, jjx, SX, NFX;

	begin
			SX:=GetXSize(FULLX);	   	  		 		   	   	  				//get the x dimension of the input array
			NFX:=GetYSize(FULLX);												//get the y dimension of the input array

				Combo:=CreateEditor('Out'+FNAME);        		 				//create an output window
				HEADER(Combo,'','');											//This procedure will generate header for output ASCII file
		for jjx:=0 to NFX-1 do													//step through the lines of the input array
     	 	begin		 
         		Write(Combo, Start+jjx) ;										//Write the radial pixel number
     				for jx:=0 to Integer(SX-1) do								//step through the columns of the input array
	 				 	 begin
         				 	  Write(Combo,',', FULLX[jx,jjx]:20:15) ;			//write the complete line into the output window
 						 end;
         					  WriteLn(Combo);						 			//terminate the line with a carriage return
			end;			 	 
				 Save(Combo, PathOUT + FNAME+FL+'.csv');						//save the output window as a *.csv file
				 Delete(Combo);		   											//delete the output window from the desktop
				 Delete(FULLX);													//delete the input array
	end;
//----------------------> end of procedure OUTRAT <-----------------



{
*************************************************************************************************
********************** procedure Radial **************************
*************************************************************************************************
{This program produce 1D radial distribution from ED image with rejection of bad points}

procedure Radial(Image_I, Image_I_SD, Mask_II, Flag);				 

var


// Flag;   			 	 			 		// flag for FULL, LEFT, RIGHT
   F_Image, Image_e;                  			//Equal radii Mask images}
   Masked_F;
   Masked_FF, Masked_FF_SD;            			//Masked ED Image and standard deviation image}
   Im_Zero_Masked_FF_SD;
   Im_One_Masked_FF_SD;
   Numerator;
   Denominator;
   Num_pix;                                     //number of pixels at certain radius
   Im_Weight, Im_Weight2;						//Image holding the weight factors and its square
   F_pix, F_pix_initial;                   		//number of pixels at certain radius
   Rad_F, Rad_F_Denominator, Rad_F_Numerator;	//Output Sum of all pixels with equal radius}
   Residual2, Weighted_Residual2;
   Sum_Weighted_Residual2;
   Prefactor;
   F_sum;                                       //variance image for left and rigth halves}
   FS;										 	//sums}
   F_std, F_stderr, F_stderr1;								//standard deviation for left and rigth halves}
   F_rej;								 		//Rejection filter}
   FR_pix;								 		//Number of pixels satisfying chosen criteria}
   FF; 										 	//Number of rejected pixels}
   Rad_FF;								 		//Corrected output sum for Radial distribution}
   Fmin, Fmax;
   Rad_sum;
   MM;
   iLoop;										//number of loops for rejection, loop index
   F_keep;
   Ed1;                                         //Output ASCII file}
   i, j;										//indices   
   ratio;
   t;							   				{indices}
   a,b;											{elliptical major and minor semi-axis}
   theta;										{scattering angle}
   CenterShift, Xr, Yr;							{Center of ellipse of given radius}
   Xt, Yt;	   	   								{Coordinates of the ellipse}
  
  
   
  begin
  
						 Data := CreateArray( single, 8, Size_x/2-Start) ;		//create an array
						 if IsNull( Data ) then		  	 				 		//if it failed
				Begin
						 WriteError( 'Insufficient memory to create array!' ) ;	//tell the user why
						 Halt;		 			   		  	 				  	//abort the program
				end
				else
				
	  Image_e:= CreateImage(typ_Binary, Size_x,Size_y);
	  for i:= 0 to 600 do							   	
  	  //for i:= 0 to Integer((Size_x-1)/2-1) do
  	  begin 
  	  	 	theta:=arctan(i/CamDist);
			
			CenterShift:=0.5*(-CamDist*sin(theta)/cos(alpha-theta)+CamDist*sin(theta)/cos(alpha+theta));
  			Xr:=X0+CenterShift*cos(beta);										//Define the center X position for each radius
			Yr:=Y0-CenterShift*sin(beta);										//Define the center Y position for each radius
			//a:=i;																// to do circular averages			
			a:=0.5*(CamDist*sin(theta)/cos(alpha-theta)+CamDist*sin(theta)/cos(alpha+theta));  //to do elliptical averages
  		   	b:=i;
			
			Image_e:=0;															//reset the variables
			t:=0;
			
			while (t<2*3.14159265) do		  									//generate elliptical mask image
    		begin	  	 					
				Xt:= Round(Xr+a*cos(t)*cos(beta)-b*sin(t)*sin(beta));			// x coordinate of the ellipse
				Yt:= Round(Yr+a*cos(t)*sin(beta)+b*sin(t)*cos(beta));			// y coordinate of the ellipse
				Image_e[Xt,Yt]:=1;
				t:=t+0.001;
			end;

		    //Show(Image_e);
			//Halt('');
		   
		   
               F_Image := Image_e and (Mask_II) and (Fuss);  					//binary ring mask of current radius
		 	   F_pix_initial:= Longint(SumOf(F_Image)); 	   	   			    //get the initial number of pixels in the ring mask image
			   
		  for iLoop:=1 to Loops do			 				 			   	   	//step through the loops
		      			
					begin						 
                         F_pix:= Longint(SumOf(F_Image)); 	   	   			    //get the number of pixels in the ring mask image
                         Masked_FF:=Single(Image_I*F_Image);				    //mask the input diffraction image
						 Masked_FF_SD:=Single(Image_I_SD*F_Image);				//mask the input standard deviation image

                if (F_pix = 0) then												//if there are no pixels in the ring
                    begin
                         Rad_F:=0;												//mean count for current radius = 0
                         F_std:=0;												//STD for a current radius = 0
                    end
                 else
					
				if (F_pix = 1) then												//if there is one pixels in the ring
                    begin
                         Rad_F:=Single(SumOf(Masked_FF));						//mean count for current radius 
                         F_std:=Single(SumOf(Masked_FF_SD));					//STD for a current radius 
                    end
                 else
					
					
					
					begin
                        
						Im_Zero_Masked_FF_SD:= (Masked_FF_SD=0);  				//Identify the zero pixels and make a binary image
						Im_One_Masked_FF_SD:=not(Im_Zero_Masked_FF_SD);			//Invert the binary image
						Masked_FF_SD:=Masked_FF_SD+100*Im_Zero_Masked_FF_SD;	//set all zero pixels to 100, so the division is possible
						
						Im_Weight:=1/(Masked_FF_SD*Masked_FF_SD);				//perform pixel by pixel division to calculate the weight image
						Im_Weight:=Im_Weight*Im_One_Masked_FF_SD;				//set all artificially altered pixels back to zero
						
						Numerator:=Masked_FF*Im_Weight;							//perform pixel by pixel division
						Denominator:=Im_Weight;									//perform pixel by pixel division
						
						Rad_F_Numerator:=Single(SumOf(Numerator));				//sum all pixels
						Rad_F_Denominator:=Single(SumOf(Denominator));			//sum all pixels
																   
                        Rad_F:=Rad_F_Numerator/Rad_F_Denominator;				// weighted mean count for current radius, see Philip Bevington, 1992, Data Reduction and Error Analysis
												
//----> calculation of weighted mean completed
											
						Residual2:=(Masked_FF-Rad_F)*(Masked_FF-Rad_F);			//calculate the residual squared image
						Residual2:=Residual2*Im_One_Masked_FF_SD;				//mask the residual square image
						Weighted_Residual2:=Residual2*Im_Weight;				//weight the squared residuals
						Sum_Weighted_Residual2:=Single(SumOf(Weighted_Residual2));		 //sum them all up
						
						Im_Weight2:=Im_Weight*Im_Weight;						//square the weight image
						Prefactor:=Single(SumOf(Im_Weight))/(Single(SumOf(Im_Weight))*Single(SumOf(Im_Weight))-Single(SumOf(Im_Weight2)));		 //calculate the prefactor
						
						F_std:= Sqrt(Prefactor*Sum_Weighted_Residual2);			//weighted standard deviation for current radius, see Philip Bevington, 1992, Data Reduction and Error Analysis	
																		
		 			end;	 													// end of if statement

//----> calculation of weighted standard deviation completed

					   Fmin:=Rad_F-Crit*F_std; 									//define the minimum pixel value to keep in a given radius
					if Fmin<0 then Fmin:=0   ;									//the mimimum value cannot be negative
					   Fmax:=Rad_F+Crit*F_std;									//define the maximum pixel value to keep in a given radius

					   F_keep:=(Masked_FF< Fmax) and (Masked_FF> Fmin);			//create a binary mask image with pixels to keep
					   
					   FR_pix:= Word(SumOf(F_keep));							//new number of pixels for current radius
					   FF:=F_pix-FR_pix;                                    	//number of rejected pixels at current loop path
	   
//-----------> Calculate corrected radial distribution

						Masked_FF:=Masked_FF*F_keep;  							//filter out oulier pixels from the masked diffraction image
						Masked_FF_SD:=Masked_FF_SD*F_keep;						//filter out the same pixels from the masked diffraction standard deviation image
						F_Image:=F_Image*F_keep;								//update the ring mask image
						F_pix:=FR_pix;											//update the number of pixels contributing to the average 


                if (F_pix = 0) then												//if there are no pixels in the ring
                    begin
                         Rad_F:=0;												//mean count for current radius = 0
                         F_std:=0;												//STD for a current radius = 0
                    end
                 else
					
				if (F_pix = 1) then												//if there is one pixels in the ring
                    begin
                         Rad_F:=Single(SumOf(Masked_FF));						//mean count for current radius 
                         F_std:=Single(SumOf(Masked_FF_SD));					//STD for a current radius 
						 F_stderr1:=F_std;
						 F_stderr:=F_std;
                    end
                 else
					
					
					
					begin
                        
						Im_Zero_Masked_FF_SD:= (Masked_FF_SD=0);  				//Identify the zero pixels and make a binary image
						Im_One_Masked_FF_SD:=not(Im_Zero_Masked_FF_SD);			//Invert the binary image
						Masked_FF_SD:=Masked_FF_SD+100*Im_Zero_Masked_FF_SD;	//set all zero pixels to 100, so the division is possible
						
						Im_Weight:=1/(Masked_FF_SD*Masked_FF_SD);				//perform pixel by pixel division to calculate the weight image
						Im_Weight:=Im_Weight*Im_One_Masked_FF_SD;				//set all artificially altered pixels back to zero
						
						Numerator:=Masked_FF*Im_Weight;							//perform pixel by pixel division
						Denominator:=Im_Weight;									//perform pixel by pixel division
						
						Rad_F_Numerator:=Single(SumOf(Numerator));				//sum all pixels
						Rad_F_Denominator:=Single(SumOf(Denominator));			//sum all pixels
																   
                        Rad_F:=Rad_F_Numerator/Rad_F_Denominator;				// weighted mean count for current radius, see Philip Bevington, 1992, Data Reduction and Error Analysis
												
//----> calculation of weighted mean completed
											
						Residual2:=(Masked_FF-Rad_F)*(Masked_FF-Rad_F);			//calculate the residual squared image
						Residual2:=Residual2*Im_One_Masked_FF_SD;				//mask the residual square image
						Weighted_Residual2:=Residual2*Im_Weight;				//weight the squared residuals
						Sum_Weighted_Residual2:=Single(SumOf(Weighted_Residual2));		 //sum them all up
						
						Im_Weight2:=Im_Weight*Im_Weight;						//square the weight image
						Prefactor:=Single(SumOf(Im_Weight))/(Single(SumOf(Im_Weight))*Single(SumOf(Im_Weight))-Single(SumOf(Im_Weight2)));		 //calculate the prefactor
						//Prefactor:=F_pix/(F_pix-1)*SumOf(Im_Weight);
						
						F_std:= Sqrt(Prefactor*Sum_Weighted_Residual2);			//weighted standard deviation for current radius, see Philip Bevington, 1992, Data Reduction and Error Analysis	

//----> calculation of weighted standard deviation completed						
						
						F_stderr:=Sqrt(Single(1/SumOf(Im_Weight)));
						F_stderr1:= F_std/Sqrt(F_pix);				 			//this definition will be used, because the spread among the radius
																				//is much bigger than the uncertainty in each pixels value obtained form the frame averages.
//----> calculation of the standard error completed					 					   				
						
																								
		 			end;	 													// end of if statement


			
					   	
																											
                        if (F_pix_initial=0) then
						   begin
						   
						   ratio:=0;
						   WriteStatus('pix=', Start+i, ', Loop=', iLoop, ', mean=', Rad_F, ', std=', F_std, ', stderr=', F_stderr, ',  Rejected pixels=',FF, ',  Remaining pixels=',F_pix, ' of ',F_pix_initial);  //write the output in the info bar
						   						   
						   end
						   else 
						   begin
						   
						   ratio:=(Single(F_pix)/Single(F_pix_initial));   		//fraction of used pixels
						   WriteStatus('pix=', Start+i, ', Loop=', iLoop, ', mean=', Rad_F, ', std=', F_std, ', stderr=', F_stderr:8:7, ', stderr1=', F_stderr1:8:7, ',  Rejected=',FF, ',  Remaining=',F_pix, ' of ',F_pix_initial, ', =',(ratio*100), '%');  //write the output in the info bar
					   
						   end;				   			   		   		  	 	// end of if statement
			end;		   														// end of loop iLoop

								
				
				
				Data[0,i]:=Start+i;		  	 		  		   	  		 		//the first column of the array contains the radial pixel information
				Data[1,i]:=Rad_F;												//the second column contains the mean intensity
			   if (F_pix=0) then	 	 		   			   		   			//if the number of pixels in the radius is one
			  begin 
				Data[2,i]:=0;													//the second column is the standard error
				Data[3,i]:=0;													//the second column is the standard error
			  end
			  else			
				begin
				Data[2,i]:=3*F_stderr1;											//the second column is three times the standard error of the weighted mean 
				//Halt(3*F_stderr);
				Data[3,i]:=3*F_stderr;											//the second column is three times the propagated standard error of the wighted mean
				end;
				
				Data[4,i]:=F_std;		 										//the third column is the standard deviation of the radial average
				Data[5,i]:=F_pix;		 										//the forth column is the number of pixels in the current radius
				Data[6,i]:=F_pix_initial;										//the fifth column is the initial number of pixels in the current radius
				Data[7,i]:=ratio;		 										//the sixth column is the fraction of used pixels


			
				
Free(F_sum);																	//Free memory

              end; 						 										// end of loop i

//------> Free memory

		  	   		 															//Free memory
	Delete(Masked_FF);
	Delete(Masked_F);
	Delete(Image_e);
	Delete(F_Image);

	
//---------> Create Output ASCII file
    	 Ed1:=CreateEditor(Flag+SamName);										//Create an window for text output
          WriteLn(Ed1,'pix', ',', 'Weighted Mean', ',', '3 * Weighted STDErr', ',', '3 * Weighted STDErr (porpagated)', ',', 'Weighted STDev', ',', 'Npix_used', ',', 'Npix_initial', ',', 'fraction used') ;		//Write the title row
		  
     for j:=0 to Integer(Size_x/2-1-Start) do  				 		 			//go through all lines of the array data
	 begin
         Write(Ed1, ShortInt(Data[0,j]), ',', Data[1,j]:20:15, ',', Data[2,j]:20:15, ',', Data[3,j]:20:15, ',', Data[4,j]:20:15, ',', Integer(Data[5,j]), ',', Integer(Data[6,j]), ',', Data[7,j]:5:4) ;  //Write the contents of the array data
         WriteLn(Ed1);					 	  				   					//end with a blank line
 	 end;	 
		 Save(Ed1, Path+Sub+Raw + Flag + SamName + FL + '.csv');				//save the output as a *.csv file

		 Delete(Ed1);			  	   	 		   	  							//delete the output window from the desktop
end;
//---------------> End of procedure Radial <------------------------------

{
 ************************************************************************
 ************************************************************************
 ***                                                                  ***
 ***	                      Main program							  ***
 ***																  ***
 ************************************************************************ 
 ************************************************************************
}

begin

//-----------------------> Initialization parameters<---------------------------------------

	 		Sel:=SELECT;												 // selector for initialization file

{------> Set Center coordinates}
						      				 	  						  
				 X0:=Val(ReadPrivateINIString( Sel, 'Center', 'cX'));	 //read a center coordinates for X
				 Y0:=Val(ReadPrivateINIString( Sel, 'Center', 'cY'));	 //read a center coordinates for Y
				 alpha:=Val(ReadPrivateINIString( Sel, 'Center', 'alpha'));	 //read the detector tilt angle in radians
				 beta:=Val(ReadPrivateINIString( Sel, 'Center', 'beta'));	 //read the ellipse rotation angle in radians
				 CamDist:=Val(ReadPrivateINIString( Sel, 'Center', 'CameraDistance'));	 //read the CameraDistance in cm
				 CamDist:=CamDist*10000/60;				 		   		 //convert to unit of pixels
			
	 			 Path:= ReadPrivateINIString( Sel, 'Paths', 'Path');	 //read a base path
	 			 PathU:= ReadPrivateINIString( Sel, 'Paths', 'PathU');	 //read a path for Masks
				 PathR:=ReadPrivateINIString( Sel, 'Paths', 'PathR');	 //read a path for polar image				 	

//-------->get apparatus mask				 
				 AppMask:=ReadPrivateINIString( Sel, 'Images', 'AppMask'); 		//read the apparatus mask file name 
 		    	 Open(PathU + AppMask,Fuss);							 		//read the apparatus mask image from disk
				 
				 WriteInfo('Xcenter= '+Str(X0)+ '  Ycenter= '+Str(Y0));			//Display a dialog box containing an information message.
	
                 Size_x:=GetXSize(Fuss);		   								//read the x dimension of the image
                 Size_y:=GetYSize(Fuss);										//read the y dimension of the image

				 Crit:=Val(ReadPrivateINIString( Sel, 'Reject', 'Crit'));	 	//read the rejection criterium
				 Loops:=Val(ReadPrivateINIString( Sel, 'Reject', 'Loops'));	 	//read the number of loops

				 Start:=Val(ReadPrivateINIString( Sel, 'PixelStart', 'Start'));	//first pixel number 
				 NS:=Val(ReadPrivateINIString( Sel, 'TotalDelays', 'First'));	//first frame to process
				 NF:=Val(ReadPrivateINIString( Sel, 'TotalDelays', 'Last'));	//last frame to process
				 
				 				 		 
				 Sub:=ReadPrivateINIString( Sel, 'Paths', 'Sub');		 
				 if (StrLen(FindFirstFile( Path+Sub+'*.csv', fa_Archive)) = 0) then
				 CreateDir(Path+Sub);			 		  				  	   	//create subdirectory for output
				 	 			 
				 Out:=ReadPrivateINIString( Sel, 'Paths', 'Out');		 
				 PathOUT:=Path+Sub+Out;
				 if (StrLen(FindFirstFile( PathOUT+'*.csv', fa_Archive)) = 0) then				 
				 CreateDir(PathOUT);		 		  				 	   	  	//create directory for output

				 Raw:=ReadPrivateINIString( Sel, 'Paths', 'RAW');
				 if (StrLen(FindFirstFile( Path+Sub+Raw+'*.csv', fa_Archive)) = 0) then				 
				 CreateDir(Path+Sub+Raw);		 		  				 	   	//create directory for output 		
				 				 
				 InIMG:=ReadPrivateINIString( Sel, 'Paths', 'OutIMG');				 				 

//-----------------------> end of Initialization <------------------------------------------


//--------> create output array of 1D ratios 

 				FULL:=CreateArray(Single,NF-NS+1,size_x/2-Start);							//create arrays 
 				//LEFT:=CreateArray(Single,NF-NS+1,size_x/2-Start);
 				//RIGHT:=CreateArray(Single,NF-NS+1,size_x/2-Start);
				sigmaFULL:=CreateArray(Single,NF-NS+1,size_x/2-Start);						
 				//sigmaLEFT:=CreateArray(Single,NF-NS+1,size_x/2-Start);
 				//sigmaRIGHT:=CreateArray(Single,NF-NS+1,size_x/2-Start);				
				
cur:=0;
	   //------> Browse trough files in directory defined in Path+InIMG
   for im:=NS to NF do
   	   begin   
			   delay:='delay'+Str(im);   
	   		   FL:=ReadPrivateINIString( Sel, 'FileNames', delay);
		 	   		
					Open(Path + InIMG + 'NR_' + FL +'.tif',curIm); 			  	//open the ratio image
		 			Open(Path + InIMG + 'NR_SE_' + FL +'.tif',curSDIm); 	  	//open the ratio image
					Open(Path + InIMG +'NewMask_'+ FL +'.tif',curMask);			//open the mask image
					SamName:=FL;	  		  	 								//assign the filename to SamName

//-------------> create combined <1D radial in colomns>x<sequential number of processed data>
 
							Radial(curIm, curSDIm, curMask,'Full');			//This program produces 1D radial distribution from ED image with rejection of bad points
				   					FULL[cur,..]:=Data[1,..]; 					//transfer contents of data array to FULL array
							   sigmaFULL[cur,..]:=Data[2,..];					//transfer contents of data array to sigmaFULL array
		 							Delete(Data) ;

						{	Radial(curIm, curMask, L, 'L');
				   					LEFT[cur,..]:=Data[1,..]; 
							   sigmaLEFT[cur,..]:=Data[2,..];
		 							Delete(Data) ;							

							Radial(curIm, curMask, R, 'R');
				   					RIGHT[cur,..]:=Data[1,..]; 
							   sigmaRIGHT[cur,..]:=Data[2,..];
		 							Delete(Data) ;		}					
					cur:=cur+1;					 								//increase the counter by one (move to another delay)												
			end;

			Save(FULL, PathOUT+'FULL'+FL+'.tif');								//the array as an image
			//Save(LEFT, PathOUT+'LEFT'+FL+'.tif');								//the array as an image
			//Save(RIGHT, PathOUT+'RIGHT'+FL+'.tif');							//the array as an image
			
			Save(sigmaFULL, PathOUT+'sigmaFULL'+FL+'.tif');						//the array as an image
			//Save(sigmaLEFT, PathOUT+'sigmaLEFT'+FL+'.tif');					//the array as an image
			//Save(sigmaRIGHT, PathOUT+'sigmaRIGHT'+FL+'.tif');					//the array as an image

//-------------> create ASCII output from combined images 			

		 		OUTRAT(FULL,'FULL'); 	  		   								//create ASCII output from combined images
		 		//OUTRAT(LEFT,'LEFT');		 
		 		//OUTRAT(RIGHT,'RIGHT');

		 		OUTRAT(sigmaFULL,'sigmaFULL');
		 		//OUTRAT(sigmaLEFT,'sigmaLEFT');		 
		 		//OUTRAT(sigmaRIGHT,'sigmaRIGHT');


			        PlaySound( 'C:\Program Files\Digital Optics\V++\autorun.wav' ) ;				
					WriteInfo('Calculation completed!');

//------> free memory					
			Free(Fuss);						
			Free(FULL);
			//Free(LEFT);
			//Free(RIGHT);	
			Free(sigmaFULL);
			//Free(sigmaLEFT);
			//Free(sigmaRIGHT);	
end
